<?php if(is_plugin_active('language')): ?>
    <?php
        $supportedLocales = Language::getSupportedLocales();

        if (empty($options)) {
            $options = [
                'before' => '',
                'lang_flag' => true,
                'lang_name' => true,
                'class' => '',
                'after' => '',
            ];
        }
    ?>
    <?php if($supportedLocales && count($supportedLocales) > 1): ?>
        <?php
            $languageDisplay = setting('language_display', 'all');
            $showRelated = setting('language_show_default_item_if_current_version_not_existed', true);
        ?>

        <div class="language-switcher-mobile">
            <div class="title"><?php echo e(__('Language')); ?></div>
            <div class="dropdown">
                <a class="dropdown-toggle" style="cursor: pointer!important;" data-bs-toggle="dropdown">
                    <?php if(Arr::get($options, 'lang_name', true) && ($languageDisplay == 'all' || $languageDisplay == 'name')): ?>
                        &nbsp;<span class="language-selected"><?php echo e(Language::getCurrentLocaleName()); ?></span>
                    <?php endif; ?>
                </a>
                <ul class="dropdown-menu">
                    <?php $__currentLoopData = $supportedLocales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $localeCode => $properties): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($localeCode != Language::getCurrentLocale()): ?>
                            <li>
                                <a class="dropdown-item" href="<?php echo e($showRelated ? Language::getLocalizedURL($localeCode) : url($localeCode)); ?>">
                                    <?php if(Arr::get($options, 'lang_flag', true) && ($languageDisplay == 'all' || $languageDisplay == 'flag')): ?>
                                        <?php echo language_flag($properties['lang_flag']); ?> <span class="ms-2"><?php echo e($properties['lang_name']); ?></span>
                                    <?php endif; ?>
                                    <?php if(Arr::get($options, 'lang_name', true) &&  ($languageDisplay == 'name')): ?>
                                        &nbsp;<?php echo e($properties['lang_name']); ?>

                                    <?php endif; ?>
                                </a>
                            </li>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        </div>
    <?php endif; ?>
<?php endif; ?><?php /**PATH C:\xampp\htdocs\Mane_website\platform\themes/apexa/partials/language-switcher-mobile.blade.php ENDPATH**/ ?>