<?php
    $bgColor = $shortcode->background_color;
    $bgImage = $shortcode->background_image ? RvMedia::getImageUrl($shortcode->background_image) : null;

    $variablesStyle = [
        "--background-color: $bgColor" => $bgColor,
        "--background-image: url($bgImage)" => $bgImage,
    ];
?>

<section class="services__area-six services__bg-six shortcode-services-tab" style="<?php echo \Illuminate\Support\Arr::toCssStyles($variablesStyle) ?>">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <div class="section-title white-title mb-40">
                    <?php if($subtitle = $shortcode->subtitle): ?>
                        <span class="sub-title"><?php echo Basehelper::clean($subtitle); ?></span>
                    <?php endif; ?>

                    <?php if($title = $shortcode->title): ?>
                        <h2 class="title"><?php echo Basehelper::clean($title); ?></h2>
                    <?php endif; ?>
                </div>
            </div>

            <?php if(($buttonUrl = $shortcode->button_url) && ($buttonLabel = $shortcode->button_label)): ?>
                <div class="col-lg-6">
                    <div class="section-more-btn">
                        <a href="<?php echo e($buttonUrl); ?>" class="btn border-btn"><?php echo BaseHelper::clean($buttonLabel); ?></a>
                    </div>
                </div>
            <?php endif; ?>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="services__tab-wrap">
                    <ul class="nav nav-tabs" id="myTab" role="tablist">
                        <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="nav-item" role="presentation">
                                <button
                                    class="<?php echo \Illuminate\Support\Arr::toCssClasses(['nav-link', 'active' => $loop->first]); ?>"
                                    id="service-<?php echo e($service->getKey()); ?>"
                                    data-bs-toggle="tab"
                                    data-bs-target="#service-<?php echo e($service->getKey()); ?>-tab"
                                    type="button" role="tab"
                                    aria-controls="service-<?php echo e($service->getKey()); ?>-tab"
                                    aria-selected="true"
                                >
                                   <span class="icon">
                                        <?php if($iconImage = $service->getMetaData('icon_image', true)): ?>
                                           <?php echo e(RvMedia::image($iconImage, 'icon')); ?>

                                       <?php elseif($icon = $service->getMetaData('icon', true)): ?>
                                           <?php if (isset($component)) { $__componentOriginal73995948b3bd877b76251b40caf28170 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal73995948b3bd877b76251b40caf28170 = $attributes; } ?>
<?php $component = Botble\Icon\View\Components\Icon::resolve(['name' => $icon] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('core::icon'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Botble\Icon\View\Components\Icon::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal73995948b3bd877b76251b40caf28170)): ?>
<?php $attributes = $__attributesOriginal73995948b3bd877b76251b40caf28170; ?>
<?php unset($__attributesOriginal73995948b3bd877b76251b40caf28170); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal73995948b3bd877b76251b40caf28170)): ?>
<?php $component = $__componentOriginal73995948b3bd877b76251b40caf28170; ?>
<?php unset($__componentOriginal73995948b3bd877b76251b40caf28170); ?>
<?php endif; ?>
                                       <?php endif; ?>
                                   </span> <?php echo e($service->name); ?>

                                </button>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                    <div class="tab-content" id="myTabContent">
                        <?php $__currentLoopData = $tabs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tab): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $service = $services->where('id', $tab['service_id'])->first();
                                $featuredTitles = array_filter( array_map(function (int $index) use ($tab) {
                                    if (! $title = Arr::get($tab, "featured_title_$index")) {
                                        return null;
                                    }

                                    return $title;
                                }, range(1, 5)));

                            ?>
                            <div class="<?php echo \Illuminate\Support\Arr::toCssClasses(['tab-pane fade', 'show active' => $loop->first]); ?>" id="service-<?php echo e($tab['service_id']); ?>-tab" role="tabpanel" aria-labelledby="service-<?php echo e($tab['service_id']); ?>-tab" tabindex="0">
                                <div class="services__item-four shine-animate-item">
                                    <?php if($image = Arr::get($tab, 'image', $service->image)): ?>
                                        <div class="services__thumb-four shine-animate">
                                            <?php echo e(RvMedia::image($image, $tab['title'])); ?>

                                        </div>
                                    <?php endif; ?>

                                    <div class="services__content-four">
                                        <h2 class="title"><a href="<?php echo e($service->url); ?>"><?php echo BaseHelper::clean($tab['title']); ?></a></h2>
                                        <?php if($description = Arr::get($tab, 'description', $service->description)): ?>
                                            <p><?php echo BaseHelper::clean($description); ?></p>
                                        <?php endif; ?>

                                        <?php if(count($featuredTitles)): ?>
                                            <div class="about__list-box">
                                                <ul class="list-wrap">
                                                    <?php $__currentLoopData = $featuredTitles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $featuredTitle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <li><i class="fas fa-check"></i><?php echo BaseHelper::clean($featuredTitle); ?></li>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                            </div>
                                        <?php endif; ?>
                                        <a
                                            href="<?php echo e(Arr::get($tab, 'button_url') ?: $service->url); ?>"
                                            class="btn"
                                        >
                                            <?php echo BaseHelper::clean(Arr::get($tab, 'button_label') ?:  __('Read More')); ?>

                                        </a>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php /**PATH C:\xampp\htdocs\Mane_website\platform\themes/apexa/partials/shortcodes/services-tab/index.blade.php ENDPATH**/ ?>