<?php use \Theme\Apexa\Support\ThemeHelper; ?>

<div class="blog-post-item shine-animate-item">
    <div class="blog-post-thumb">
        <a href="<?php echo e($post->url); ?>" class="shine-animate">
            <?php echo e(RvMedia::image($post->image, $post->name, 'medium-square')); ?>

        </a>
        <?php if(ThemeHelper::isShowPostMeta('list', 'category', true)): ?>
            <?php echo Theme::partial('blog.post-meta.category-badge', compact('post')); ?>

        <?php endif; ?>

    </div>
    <div class="blog-post-content">
        <h2 class="title"><a class="truncate-2-custom" title="<?php echo e($post->name); ?>" href="<?php echo e($post->url); ?>"><?php echo e($post->name); ?></a></h2>
        <?php if(ThemeHelper::isShowPostMeta('list', 'author_name', true)): ?>
            <?php echo Theme::partial('blog.post-meta.author', compact('post')); ?>

        <?php endif; ?>

        <div class="blog-post-meta">
            <ul class="list-wrap">
                <li>
                    <a href="<?php echo e($post->url); ?>" class="btn"><?php echo e(__('Read More')); ?></a>
                </li>

                <?php if(ThemeHelper::isShowPostMeta('list', 'published_date', true)): ?>
                    <li><?php echo Theme::partial('blog.post-meta.published-date', compact('post')); ?></li>
                <?php endif; ?>
            </ul>
        </div>
    </div>
</div>
<?php /**PATH C:\xampp\htdocs\Mane_website\platform\themes/apexa/partials/blog/post-styles/style-1.blade.php ENDPATH**/ ?>