<section class="shortcode-testimonials shortcode-testimonials-style-1 testimonial-area" style="<?php echo \Illuminate\Support\Arr::toCssStyles($variablesStyle) ?>">
    <div class="container">
        <div class="row align-items-center justify-content-center">
            <div class="col-lg-6 order-0 order-lg-2">
                <div class="swiper-container testimonial-active">
                    <div class="swiper-wrapper">
                        <?php $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="swiper-slide">
                                <div class="testimonial-item">
                                    <div class="testimonial-info">
                                        <?php if($name = $testimonial->name): ?>
                                            <h4 class="title"><?php echo BaseHelper::clean($name); ?></h4>
                                        <?php endif; ?>

                                        <?php if($company = $testimonial->company): ?>
                                            <span><?php echo BaseHelper::clean($company); ?></span>
                                        <?php endif; ?>
                                    </div>

                                    <div class="testimonial__rating">
                                        <?php
                                            $ratingStar = round((int) $testimonial->getMetaData('rating_star', true))
                                        ?>

                                        <?php $__currentLoopData = range(1, 5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <i class="<?php echo \Illuminate\Support\Arr::toCssClasses(['fas fa-star', 'unstar' => $i > $ratingStar]); ?>"></i>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>

                                    <?php if($content = $testimonial->content): ?>
                                        <div class="testimonial-content">
                                            <p><?php echo BaseHelper::clean($content); ?></p>
                                            <div class="icon"><i class="fas fa-quote-right"></i></div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
                <div class="testimonial-slider-dot">
                    <div class="swiper testimonial-nav">
                        <div class="swiper-wrapper">
                            <?php $__currentLoopData = $testimonials->pluck('name', 'image'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $avatar => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="swiper-slide">
                                    <button>
                                        <?php echo e(RvMedia::image($avatar, $name, 'thumb')); ?>

                                    </button>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 col-md-8">
                <?php if($image = $shortcode->image): ?>
                    <div class="testimonial-img-wrap">
                        <?php echo e(RvMedia::image($image, 'testimonial-image')); ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>
<?php /**PATH C:\xampp\htdocs\Mane_website\platform\themes/apexa/partials/shortcodes/testimonials/styles/style-1.blade.php ENDPATH**/ ?>