<?php
    $isDefaultLanguage = !defined('LANGUAGE_ADVANCED_MODULE_SCREEN_NAME') || !request()->input('ref_lang') || request()->input('ref_lang') == Language::getDefaultLocaleCode();
?>

<div
    class="col-md-12"
    id="custom-field-options"
>
    <table class="table table-bordered setting-option">
        <thead>
            <tr>
                <?php if($isDefaultLanguage): ?>
                    <th scope="col">#</th>
                <?php endif; ?>
                <th scope="col"><?php echo e(trans('plugins/portfolio::portfolio.custom_field.option.label')); ?></th>
                <th
                    scope="col"
                    colspan="2"
                ><?php echo e(trans('plugins/portfolio::portfolio.custom_field.option.value')); ?></th>
            </tr>
        </thead>
        <tbody class="option-sortable">
            <?php if($options->count()): ?>
                <?php $__currentLoopData = $options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr
                        class="option-row ui-state-default"
                        data-index="<?php echo e($value->id); ?>"
                    >
                        <input
                            name="options[<?php echo e($key); ?>][id]"
                            type="hidden"
                            value="<?php echo e($value->id); ?>"
                        >
                        <input
                            name="options[<?php echo e($key); ?>][order]"
                            type="hidden"
                            value="<?php echo e($value->order !== 999 ? $value->order : $key); ?>"
                        >
                        <?php if($isDefaultLanguage): ?>
                            <td class="text-center">
                                <i class="fa fa-sort"></i>
                            </td>
                        <?php endif; ?>
                        <td>
                            <input
                                class="form-control option-label"
                                name="options[<?php echo e($key); ?>][label]"
                                type="text"
                                value="<?php echo e($value->label); ?>"
                                placeholder="<?php echo e(trans('plugins/portfolio::portfolio.custom_field.option.label')); ?>"
                            />
                        </td>
                        <td>
                            <input
                                class="form-control option-value"
                                name="options[<?php echo e($key); ?>][value]"
                                type="text"
                                value="<?php echo e($value->value); ?>"
                                placeholder="<?php echo e(trans('plugins/portfolio::portfolio.custom_field.option.value')); ?>"
                            />
                        </td>
                        <?php if($isDefaultLanguage): ?>
                            <td style="width: 50px">
                                <button
                                    class="btn btn-default remove-row"
                                    data-index="0"
                                    type="button"
                                >
                                    <i class="fa fa-trash"></i>
                                </button>
                            </td>
                        <?php endif; ?>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
                <tr
                    class="option-row"
                    data-index="0"
                >
                    <?php if($isDefaultLanguage): ?>
                        <td class="text-center">
                            <i class="fa fa-sort"></i>
                        </td>
                    <?php endif; ?>
                    <td>
                        <input
                            class="form-control option-label"
                            name="options[0][label]"
                            type="text"
                            placeholder="<?php echo e(trans('plugins/portfolio::portfolio.custom_field.option.label')); ?>"
                        />
                    </td>
                    <td>
                        <input
                            class="form-control option-value"
                            name="options[0][value]"
                            type="text"
                            placeholder="<?php echo e(trans('plugins/portfolio::portfolio.custom_field.option.value')); ?>"
                        />
                    </td>
                    <?php if($isDefaultLanguage): ?>
                        <td style="width: 50px">
                            <button
                                class="btn btn-default remove-row"
                                data-index="0"
                                type="button"
                            >
                                <i class="fa fa-trash"></i>
                            </button>
                        </td>
                    <?php endif; ?>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <?php if($isDefaultLanguage): ?>
        <button
            class="btn btn-info mt-3"
            id="add-new-row"
            type="button"
        ><?php echo e(trans('plugins/portfolio::portfolio.custom_field.option.add_row')); ?></button>
    <?php endif; ?>
</div>
<?php /**PATH C:\xampp\htdocs\Mane_website\platform/plugins/portfolio/resources/views/custom-fields/options.blade.php ENDPATH**/ ?>